//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Sign and create Signed PKCS-7 message
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define PKCS7S_FILE "pkcs7_sig_ex.bin"
#define CERT1 "us1.cer"
#define CERT2 "us2.cer"
#define CERT3 "us3.cer"
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//         
// :
// 1.  
// 2.  Signed PKCS-7 message:
//    -  
//    -   3- 
//    -    mail
//    -    IP
//    -  2 
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
unsigned char Cert1[8196];
unsigned char Cert2[8196];
unsigned char Cert3[8196];
char *Data_for_sign=(char*)"1234567890ABCD";
//------------------------------------------------------------------------------
#define OID_PKCS9_EmailAddress        "1.2.840.113549.1.9.1"
#define OID_PKCS9_UnstructuredName    "1.2.840.113549.1.9.2"
const char *mail="user@example.com",*IP="192.168.1.1";
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTHASH hHash=0;
 DWORD len,l,sz1,sz2,sz3;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //  1- 
 if (getFileLen(CERT1,     &sz1)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CERT1,Cert1,sz1)) {printf("readFile error\r\n");   return 1;}
 //  2- 
 if (getFileLen(CERT2,     &sz2)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CERT2,Cert2,sz2)) {printf("readFile error\r\n");   return 1;}
 //  3- 
 if (getFileLen(CERT3,     &sz3)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CERT3,Cert3,sz3)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,(char*)CSP_PROF,0,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //  -
 if (!CPCreateHash(hProv,CALG_TGR3411,0,0,&hHash)) {
   printf("CPCreateHash Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPHashData(hProv,hHash,(BYTE*)Data_for_sign,strlen(Data_for_sign),0)) {
   printf("CPHashData Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPSetHashParam(hProv,hHash,HP_PKCS7_CERTIFICATE,Cert1,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 if (!CPSetHashParam(hProv,hHash,HP_PKCS7_CERTIFICATE,Cert2,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 if (!CPSetHashParam(hProv,hHash,HP_PKCS7_CERTIFICATE,Cert3,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 len=strlen(Data_for_sign);
 if (!CPSetHashParam(hProv,hHash,HP_PKCS7_DATA_SIZE,(BYTE*)&len,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 if (!CPSetHashParam(hProv,hHash,HP_PKCS7_DATA,(BYTE*)Data_for_sign,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    mail
 if (!CPSetHashParam(hProv,hHash,HP_PKCS9_CUR_OID,(BYTE*)OID_PKCS9_EmailAddress,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 len=strlen(mail);
 if (!CPSetHashParam(hProv,hHash,HP_PKCS9A_SIZE,(BYTE*)&len,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 if (!CPSetHashParam(hProv,hHash,HP_PKCS9A_DATA,(BYTE*)mail,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //    IP
 if (!CPSetHashParam(hProv,hHash,HP_PKCS9_CUR_OID,(BYTE*)OID_PKCS9_UnstructuredName,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 len=strlen(IP);
 if (!CPSetHashParam(hProv,hHash,HP_PKCS9U_SIZE,(BYTE*)&len,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 if (!CPSetHashParam(hProv,hHash,HP_PKCS9U_DATA,(BYTE*)IP,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //
 //  PKCS7
 len=sizeof(WBuf);
 if (!CPSignHash(hProv,hHash,AT_SIGNATURE,NULL,CRYPT_SIGN_PKCS7,WBuf,&len)) {
   printf("CPSignHash Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 writeFile(PKCS7S_FILE,WBuf,len);
 //
 //    TRANSACTION_ID
 if (!CPSetHashParam(hProv,hHash,HP_PKCS9_CUR_OID,(BYTE*)OID_TRANSACTION_ID,0)) {
   printf("CPSetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 len=sizeof(l);
 if (CPGetHashParam(hProv,hHash,HP_PKCS9A_SIZE,(BYTE*)&l,&len,0)) {
   len=sizeof(WBuf);
   if (!CPGetHashParam(hProv,hHash,HP_PKCS9A_DATA,WBuf,&len,0)) {
     printf("CPGetHashParam Error: %0X\n",GetLastErrorCSP(hProv));
     return 1;
   }
   WBuf[len]=0;
   printf("transactionID = %s\n",(char*)WBuf);
 }
 //
 CPDestroyHash(hProv,hHash);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
